local assets=
{
	Asset("ANIM", "anim/axe.zip"),
	Asset("ANIM", "anim/goldenaxe.zip"),
	Asset("ANIM", "anim/swap_axe.zip"),
	Asset("ANIM", "anim/swap_goldenaxe.zip"),
}

local function onfinished(inst)
    inst:Remove()
end

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_axe", "swap_axe")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("axe")
    anim:SetBuild("axe")
    anim:PlayAnimation("idle")
    
    inst:AddTag("sharp")
    
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.AXE_DAMAGE)

    -----
    inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.CHOP)
    -------

    -------
    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    
    inst:AddComponent("equippable")

    inst.components.equippable:SetOnEquip( onequip )
    
    inst.components.equippable:SetOnUnequip( onunequip)

  --  self.atlasname = 
    return inst
end

local function onequipgold(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_lucy_axe", "swap_lucy_axe")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end
    
local function golden(Sim)
	local inst = fn(Sim)
	inst.AnimState:SetBuild("goldenaxe")
	inst.AnimState:SetBank("goldenaxe")
    inst.components.equippable:SetOnEquip( onequipgold )
    inst.components.inventoryitem:ChangeImageName("lucy")

	
	
	
	
		local ownertag = "woodie"
		local function undropppable(inst)
				local owner1 = FindEntity(inst, 1, function(guy) return (guy:HasTag("player3") and guy:HasTag(ownertag) and not guy.components.health:IsDead())end)
				if owner1 then
					local action = ACTIONS.PICKUP 
					local ba = BufferedAction(owner1, inst, action)
					owner1.components.locomotor:PushAction(ba, true)
				end

				
				inst:DoTaskInTime(0.5, function() 
					if inst.components.inventoryitem and inst.components.inventoryitem.owner and inst.components.inventoryitem.owner==nil then
						inst:Remove()
					elseif not owner1 then
						inst:Remove()
					end
				end)
		end
		inst:DoPeriodicTask(10, function()
			inst.components.inventoryitem:ChangeImageName("lucy")
			if inst.components.inventoryitem and inst.components.inventoryitem.owner and inst.components.inventoryitem.owner==GetPlayer() then
				inst:Remove()
			end
		end)
		inst:AddTag("specialitemplayer3")
		inst:ListenForEvent("ondropped", undropppable) 
	
	
	
	
	
	
	return inst
end

return Prefab( "common/inventory/axe_player_3", golden, assets)

